/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public final class BlockBush
extends BlockGrowingPlant {
    public static final int BLUEBERRY = 0;
    public static final String[] types = new String[]{"blueberry"};
    private ms[] icons;

    protected BlockBush(int id2) {
        super(id2);
        float width = 0.3f;
        float height = 0.6f;
        this.setBlockBoundsForAllThreads(0.5f - width, 0.0, 0.5f - width, 0.5f + width, height, 0.5f + width);
    }

    @Override
    public void a(mt icon_register) {
        this.icons = new ms[types.length * 2];
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (types[i2] == null) continue;
            this.icons[i2 * 2] = icon_register.a(this.E() + "/" + types[i2]);
            this.icons[i2 * 2 + 1] = icon_register.a(this.E() + "/" + types[i2] + "_picked");
        }
    }

    @Override
    public ms a(int side, int metadata) {
        return this.icons[this.getBlockSubtype(metadata) * 2 + (BlockBush.hasBerries(metadata) ? 0 : 1)];
    }

    @Override
    public String getMetadataNotes() {
        return "Bits 1 and 2 used for subtype, bits 4 and 8 used to track berry growth";
    }

    @Override
    public boolean isValidMetadata(int metadata) {
        return (metadata & 3) < types.length;
    }

    @Override
    public int getBlockSubtypeUnchecked(int metadata) {
        return metadata & 3;
    }

    @Override
    public int getItemSubtype(int metadata) {
        return BlockBush.setBerryGrowth(this.getBlockSubtype(metadata), BlockBush.getMaxBerryGrowth());
    }

    public static int getMaxBerryGrowth() {
        return 3;
    }

    public static boolean hasBerries(int metadata) {
        return BlockBush.getBerryGrowth(metadata) == BlockBush.getMaxBerryGrowth();
    }

    public static int setBerryGrowth(int metadata, int growth) {
        return metadata & 3 | ls.a(growth, 0, BlockBush.getMaxBerryGrowth()) << 2;
    }

    public static int getBerryGrowth(int metadata) {
        return metadata >> 2;
    }

    public static int incrementBerryGrowth(int metadata) {
        return BlockBush.setBerryGrowth(metadata, BlockBush.getBerryGrowth(metadata) + 1);
    }

    public static int setToMaximumBerryGrowth(int metadata) {
        return BlockBush.setBerryGrowth(metadata, BlockBush.getMaxBerryGrowth());
    }

    public static int getMetadataForBushWithBerries(int subtype) {
        return BlockBush.setToMaximumBerryGrowth(subtype);
    }

    @Override
    public int getMinAllowedLightValue() {
        return 8;
    }

    @Override
    public int getMaxAllowedLightValue() {
        return 15;
    }

    @Override
    public boolean dropsAsSelfWhenTrampled(nn entity) {
        return false;
    }

    public boolean isBiomeSuitable(acq biome, int metadata) {
        return biome == acq.f || biome == acq.t;
    }

    @Override
    public boolean canBePlacedAt(abw world, int x2, int y2, int z2, int metadata) {
        return this.isBiomeSuitable(world.a(x2, z2), metadata) && world.l(x2, y2, z2) && super.canBePlacedAt(world, x2, y2, z2, metadata);
    }

    @Override
    public int getPatchSize(acq biome) {
        return 64;
    }

    @Override
    public boolean onBlockActivated(abw world, int x2, int y2, int z2, uf player, EnumFace face, float offset_x, float offset_y, float offset_z) {
        int metadata = world.h(x2, y2, z2);
        if (!BlockBush.hasBerries(metadata)) {
            return false;
        }
        if (player.onServer()) {
            this.dropBlockAsEntityItem(new BlockBreakInfo(world, x2, y2, z2).setPickedBy(player), yc.blueberries);
            world.f(x2, y2, z2, this.cF, BlockBush.setBerryGrowth(metadata, 0), 2);
        }
        return true;
    }

    public boolean fertilize(abw world, int x2, int y2, int z2, ye item_stack) {
        yc item = item_stack.b();
        if (item == yc.aY) {
            int metadata = world.h(x2, y2, z2);
            if (BlockBush.hasBerries(metadata)) {
                return false;
            }
            if (!world.I) {
                int growth_added = ls.a(world.s, 1, 2);
                while (growth_added-- > 0) {
                    metadata = BlockBush.incrementBerryGrowth(metadata);
                }
                world.b(x2, y2, z2, metadata, 2);
            }
            return true;
        }
        return false;
    }

    @Override
    public int dropBlockAsItself(BlockBreakInfo info) {
        return this.dropBlockAsEntityItem(info) + super.dropBlockAsItself(info);
    }

    @Override
    public int dropBlockAsEntityItem(BlockBreakInfo info) {
        if (BlockBush.hasBerries(info.getMetadata()) && (info.wasHarvestedByPlayer() || info.wasSelfDropped() || info.wasNotLegal())) {
            return this.dropBlockAsEntityItem(info, yc.blueberries);
        }
        return 0;
    }

    @Override
    public int getMetadataForPlacement(abw world, int x2, int y2, int z2, ye item_stack, nn entity, EnumFace face, float offset_x, float offset_y, float offset_z) {
        return entity instanceof uf && entity.getAsPlayer().inCreativeMode() ? item_stack.getItemSubtype() : BlockBush.setBerryGrowth(item_stack.getItemSubtype(), 0);
    }

    @Override
    public float getGrowthRate(abw world, int x2, int y2, int z2) {
        float growth_rate = 0.1f;
        acq biome = world.a(x2, z2);
        growth_rate *= this.getTemperatureGrowthRateModifier(biome.F);
        growth_rate *= this.getHumidityGrowthRateModifier(biome.e());
        return growth_rate *= this.getGlobalGrowthRateModifierFromMITE();
    }

    @Override
    public boolean updateTick(abw world, int x2, int y2, int z2, Random rand) {
        if (super.updateTick(world, x2, y2, z2, rand)) {
            return true;
        }
        int metadata = world.h(x2, y2, z2);
        if (BlockBush.hasBerries(metadata)) {
            return false;
        }
        int berry_growth = BlockBush.getBerryGrowth(metadata);
        float growth_rate = this.getGrowthRate(world, x2, y2, z2);
        if (growth_rate == 0.0f) {
            return false;
        }
        int blv2 = world.n(x2, y2 + 1, z2);
        if (this.isLightLevelSuitableForGrowth(blv2) && rand.nextFloat() < growth_rate) {
            world.b(x2, y2, z2, BlockBush.incrementBerryGrowth(metadata), 2);
            return true;
        }
        return false;
    }

    @Override
    public float getLowestOptimalTemperature() {
        return acq.t.F;
    }

    @Override
    public float getHighestOptimalTemperature() {
        return acq.f.F;
    }

    @Override
    public float getHumidityGrowthRateModifier(boolean high_humidity) {
        return 1.0f;
    }
}

